SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'ResNextIntervCall' AND object_id = OBJECT_ID(N'Respondent'))
BEGIN
  ALTER TABLE Respondent ADD ResNextIntervCall [nvarchar] (10) NULL
END
GO

---------------------------
-- VX_Sp_GetDeassignedCases
----------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_Sp_GetDeassignedCases]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_Sp_GetDeassignedCases]
GO
CREATE PROCEDURE [VX_Sp_GetDeassignedCases]
	@listOfCases AS nvarchar (max),
	@userId AS int,
	@projectId AS int
AS
BEGIN
 SET NOCOUNT ON;
 DECLARE @cmd nvarchar(max)
 -- cases that the use is no longer assigned to
 SET @cmd = 'SELECT [ResRespondent] AS ''CaseId'','+ LTRIM(STR(@projectId)) + ' AS ''ProjectId'' FROM [Respondent] WHERE ([Location]=''Server'' OR [ResIntervCall]<>' + LTRIM(STR(@userId)) + ') AND [ResRespondent] IN (' + @listOfCases + ')'
 SET @cmd=@cmd+' UNION '
 -- cases that the use will be assigned to next interviewer
 SET @cmd = 'SELECT [ResRespondent] AS ''CaseId'','+ LTRIM(STR(@projectId)) + ' AS ''ProjectId'' FROM [Respondent] WHERE ([ResNextIntervCall] IS NOT NULL AND [ResNextIntervCall]<>'''' ) AND [ResRespondent] IN (' + @listOfCases + ')'
 SET @cmd=@cmd+' UNION '
 -- Add cases deleted on server
 SET @cmd=@cmd+'SELECT DISTINCT delRes.[Respondent] AS ''CaseId'','+ LTRIM(STR(@projectId)) + ' AS ''ProjectId'' FROM [RespondentModifLog] AS delRes'
 SET @cmd=@cmd+' INNER JOIN (SELECT [Respondent],MAX([modified]) AS Last FROM [RespondentModifLog] WHERE [Respondent] IN (' + @listOfCases + ')'
 SET @cmd=@cmd+' GROUP BY [Respondent]) AS lstAct ON lstAct.[Last]=delRes.[modified] AND lstAct.[Respondent]=delRes.[Respondent]'
 SET @cmd=@cmd+'WHERE delRes.[Action]=''Delete'''
 EXEC sp_executesql @cmd
END
GO

